/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.paginas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.editores.EditorBase;
import ec.gob.sri.dimm.api.ui.listeners.DropdownSelectionListener;
import ec.gob.sri.dimm.api.ui.paginas.PaginaBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteExpandableComposite;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.api.ui.visores.ProveedorEtiquetasTabla;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Comprador;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Establecimiento;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Venta;
import ec.gob.sri.dimm.ats.modelo.validator.rule.VentasValidationRule;
import ec.gob.sri.dimm.ats.ui.asistentes.ventas.AsistenteEdicionComprobanteVenta;
import ec.gob.sri.dimm.ats.ui.asistentes.ventas.AsistenteNuevoComprobanteVenta;
import ec.gob.sri.dimm.ats.ui.dialogos.DialogoCliente;
import ec.gob.sri.dimm.ats.ui.dialogos.DialogoEstablecimiento;
import ec.gob.sri.dimm.ats.ui.editores.EditorATS;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import swing2swt.layout.BorderLayout;

public class PaginaVentas
extends PaginaBase<EditorATS>
implements VistaModelo<Iva> {
    private static final String NO_HA_SELECCIONADO_UN_DETALLE_DE_LA_VENTA = "No ha seleccionado un detalle de la venta";
    private static final String NO_HA_SELECCIONADO_UN_CLIENTE_PARA_AGREGAR_COMPROBANTES = "No ha seleccionado un cliente para agregar comprobantes";
    private DataBindingContext m_bindingContext;
    private Iva modeloDatos;
    private Table table;
    private Table tblComprobantes;
    private Text txtIdentificacion;
    private ToolItem tltmNuevoVenta;
    private ToolItem tltmEditarCliente;
    private Venta clienteSeleccionado;
    private ComprobanteVenta comprobanteSeleccionado;
    private Establecimiento establecimientoSeleccionado;
    private TableViewer tvCliente;
    private ToolItem tltmEliminarCliente;
    private ExpandableComposite xcDetallesDeVentas;
    private ToolItem tltmNuevoDetVenta;
    private TableViewer tvDetallesComprobantes;
    private Button btnBuscar;
    private ToolItem tltmEliminarDetalle;
    private ToolItem tlmEditarDetalle;
    private Label lblTotal;
    private Table tblVentasEstab;
    private ToolItem tltmNuevoEstablecimiento;
    private ToolItem tltmEditarEstabl;
    private ToolItem tltmEliminarEstabl;
    private TableViewer tvVentasEstab;
    private Label lblNumEstablecimientos;
    private Label lblTotalReembolsos;
    private Menu menuEditar;
    private MenuItem tltmEditarFormasDeCobro;
    private MenuItem tltmEditarComprobante;

    public PaginaVentas(EditorATS editor, String id, String title) {
        super((EditorBase)editor, id, title);
    }

    public void setModeloDatos(Iva modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
    }

    private void btnNuevoClienteClicked() {
        this.tltmNuevoVenta.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Venta cliente = new Venta();
                cliente.setPropietario((ObjetoModelo)PaginaVentas.this.modeloDatos);
                if (PaginaVentas.this.abrirDialogoCliente(cliente.getComprador(), false)) {
                    PaginaVentas.this.modeloDatos.agregarClienteVenta(cliente);
                    ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                }
            }
        });
    }

    private void btnEditarClienteClicked() {
        this.tltmEditarCliente.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Comprador clienteCopia;
                if (PaginaVentas.this.clienteSeleccionado != null && PaginaVentas.this.abrirDialogoCliente(clienteCopia = PaginaVentas.this.clienteSeleccionado.getComprador().crearCopiaEdicion(), true)) {
                    PaginaVentas.this.clienteSeleccionado.getComprador().actualizarInformacion((Sujeto)clienteCopia);
                    PaginaVentas.this.tvCliente.refresh();
                    ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                }
            }
        });
    }

    private boolean abrirDialogoCliente(Comprador modeloDatosDialogo, boolean editando) {
        DialogoCliente dialogo = new DialogoCliente(this.getSite(), this.modeloDatos.getClientesVenta(), editando);
        dialogo.setModeloDatos(modeloDatosDialogo);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    private void eliminarClienteVentaCliked() {
        this.tltmEliminarCliente.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaVentas.this.clienteSeleccionado != null && PaginaVentas.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaVentas.this.modeloDatos.eliminarClienteVenta(PaginaVentas.this.clienteSeleccionado)) {
                    PaginaVentas.this.clienteSeleccionado = null;
                    AyudanteExpandableComposite.activar((ExpandableComposite)PaginaVentas.this.xcDetallesDeVentas, (boolean)false);
                    ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                }
            }
        });
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setDelayedReflow(true);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new ColumnLayout());
        Section sctnVentas = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        managedForm.getToolkit().paintBordersFor((Composite)sctnVentas);
        sctnVentas.setText("Ventas");
        Composite composite = new Composite((Composite)sctnVentas, 0);
        managedForm.getToolkit().adapt(composite);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnVentas.setClient((Control)composite);
        RowLayout rl_composite = new RowLayout(512);
        rl_composite.spacing = 10;
        rl_composite.marginTop = 5;
        rl_composite.marginRight = 5;
        rl_composite.marginLeft = 5;
        rl_composite.marginBottom = 5;
        composite.setLayout((Layout)rl_composite);
        Section sctnVentasCliente = managedForm.getToolkit().createSection(composite, 258);
        managedForm.getToolkit().paintBordersFor((Composite)sctnVentasCliente);
        sctnVentasCliente.setText("Ventas por Cliente");
        sctnVentasCliente.setExpanded(true);
        Composite composite_1 = new Composite((Composite)sctnVentasCliente, 0);
        managedForm.getToolkit().adapt(composite_1);
        managedForm.getToolkit().paintBordersFor(composite_1);
        sctnVentasCliente.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new FormLayout());
        ExpandableComposite xpndblcmpstClientes = managedForm.getToolkit().createExpandableComposite(composite_1, 512);
        FormData fd_xpndblcmpstClientes = new FormData();
        fd_xpndblcmpstClientes.top = new FormAttachment(0);
        fd_xpndblcmpstClientes.left = new FormAttachment(0);
        fd_xpndblcmpstClientes.bottom = new FormAttachment(0, 350);
        xpndblcmpstClientes.setLayoutData((Object)fd_xpndblcmpstClientes);
        managedForm.getToolkit().paintBordersFor((Composite)xpndblcmpstClientes);
        xpndblcmpstClientes.setText("Clientes");
        Composite composite_2 = new Composite((Composite)xpndblcmpstClientes, 0);
        managedForm.getToolkit().adapt(composite_2);
        managedForm.getToolkit().paintBordersFor(composite_2);
        xpndblcmpstClientes.setClient((Control)composite_2);
        composite_2.setLayout((Layout)new BorderLayout(0, 0));
        this.tvCliente = new TableViewer(composite_2, 67584);
        this.tvCliente.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaVentas.this.clienteSeleccionado = (Venta)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                AyudanteExpandableComposite.activar((ExpandableComposite)PaginaVentas.this.xcDetallesDeVentas, (boolean)true);
                PaginaVentas.this.comprobanteSeleccionado = null;
                AyudanteViewer.seleccionarElemento((Viewer)PaginaVentas.this.tvDetallesComprobantes, null);
            }
        });
        this.table = this.tvCliente.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)"Center");
        managedForm.getToolkit().paintBordersFor((Composite)this.table);
        TableColumn tblclmnTipoDeIdentificacin = new TableColumn(this.table, 0);
        tblclmnTipoDeIdentificacin.setWidth(150);
        tblclmnTipoDeIdentificacin.setText("Tipo de Identificaci\u00f3n");
        TableColumn tblclmnIdentificacin = new TableColumn(this.table, 0);
        tblclmnIdentificacin.setWidth(160);
        tblclmnIdentificacin.setText("Identificaci\u00f3n");
        TableColumn tblclmnTotalVenta = new TableColumn(this.table, 0);
        tblclmnTotalVenta.setWidth(100);
        tblclmnTotalVenta.setText("Total");
        Composite composite_4 = new Composite(composite_2, 0);
        composite_4.setLayoutData((Object)"North");
        managedForm.getToolkit().adapt(composite_4);
        managedForm.getToolkit().paintBordersFor(composite_4);
        GridLayout gl_composite_4 = new GridLayout(4, false);
        gl_composite_4.marginWidth = 0;
        gl_composite_4.verticalSpacing = 0;
        gl_composite_4.marginHeight = 0;
        gl_composite_4.horizontalSpacing = 0;
        composite_4.setLayout((Layout)gl_composite_4);
        ToolBar toolBar = new ToolBar(composite_4, 0x820000);
        GridData gd_toolBar = new GridData(16384, 4, false, false, 1, 1);
        gd_toolBar.widthHint = 147;
        toolBar.setLayoutData((Object)gd_toolBar);
        managedForm.getToolkit().adapt((Composite)toolBar);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar);
        this.tltmNuevoVenta = new ToolItem(toolBar, 0);
        this.tltmNuevoVenta.setText("Nuevo");
        this.tltmEditarCliente = new ToolItem(toolBar, 0);
        this.tltmEditarCliente.setText("Editar");
        this.tltmEliminarCliente = new ToolItem(toolBar, 0);
        this.tltmEliminarCliente.setText("Eliminar");
        Label lblIdentificacinCliente = new Label(composite_4, 0);
        GridData gd_lblIdentificacinCliente = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblIdentificacinCliente.widthHint = 113;
        lblIdentificacinCliente.setLayoutData((Object)gd_lblIdentificacinCliente);
        managedForm.getToolkit().adapt((Control)lblIdentificacinCliente, true, true);
        lblIdentificacinCliente.setText("Identificaci\u00f3n Cliente");
        this.txtIdentificacion = new Text(composite_4, 2048);
        GridData gd_txtIdentificacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtIdentificacion.widthHint = 109;
        this.txtIdentificacion.setLayoutData((Object)gd_txtIdentificacion);
        this.txtIdentificacion.setToolTipText("Escriba para buscar");
        this.txtIdentificacion.setMessage("Escriba para buscar...");
        managedForm.getToolkit().adapt((Control)this.txtIdentificacion, true, true);
        this.btnBuscar = new Button(composite_4, 0);
        this.btnBuscar.setImage(ResourceManager.getPluginImage((String)"ec.gob.sri.dimm.ats.ui", (String)"iconos/search.png"));
        managedForm.getToolkit().adapt((Control)this.btnBuscar, true, true);
        Composite composite_6 = new Composite(composite_2, 0);
        composite_6.setLayoutData((Object)"South");
        managedForm.getToolkit().adapt(composite_6);
        managedForm.getToolkit().paintBordersFor(composite_6);
        composite_6.setLayout((Layout)new RowLayout(256));
        Composite composite_7 = new Composite(composite_6, 0);
        composite_7.setLayoutData((Object)new RowData(408, -1));
        managedForm.getToolkit().adapt(composite_7);
        managedForm.getToolkit().paintBordersFor(composite_7);
        composite_7.setLayout((Layout)new GridLayout(2, false));
        Label lblTotalVentas = new Label(composite_7, 0);
        GridData gd_lblTotalVentas = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTotalVentas.widthHint = 140;
        lblTotalVentas.setLayoutData((Object)gd_lblTotalVentas);
        lblTotalVentas.setFont(SWTResourceManager.getFont((String)"Segoe UI", (int)9, (int)1));
        managedForm.getToolkit().adapt((Control)lblTotalVentas, true, true);
        lblTotalVentas.setText("Total Ventas Netas:");
        this.lblTotal = new Label(composite_7, 0);
        GridData gd_lblTotal = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_lblTotal.widthHint = 250;
        this.lblTotal.setLayoutData((Object)gd_lblTotal);
        managedForm.getToolkit().adapt((Control)this.lblTotal, true, true);
        Composite cReembolsos = new Composite(composite_6, 0);
        managedForm.getToolkit().adapt(cReembolsos);
        managedForm.getToolkit().paintBordersFor(cReembolsos);
        cReembolsos.setLayout((Layout)new GridLayout(2, false));
        Label lblReembolso = new Label(cReembolsos, 0);
        GridData gd_lblReembolso = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblReembolso.widthHint = 140;
        lblReembolso.setLayoutData((Object)gd_lblReembolso);
        lblReembolso.setText(this.modeloDatos.periodo.isPeriodoDeAnexoDesdeMarzo2015() ? "Total Reembolsos Netos:" : "Total Reembolsos:");
        lblReembolso.setFont(SWTResourceManager.getFont((String)"Segoe UI", (int)9, (int)1));
        managedForm.getToolkit().adapt((Control)lblReembolso, true, true);
        this.lblTotalReembolsos = new Label(cReembolsos, 0);
        GridData gd_lblTotalReembolsos = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_lblTotalReembolsos.widthHint = 250;
        this.lblTotalReembolsos.setLayoutData((Object)gd_lblTotalReembolsos);
        managedForm.getToolkit().adapt((Control)this.lblTotalReembolsos, true, true);
        this.xcDetallesDeVentas = managedForm.getToolkit().createExpandableComposite(composite_1, 512);
        FormData fd_xcDetallesDeVentas = new FormData();
        fd_xcDetallesDeVentas.left = new FormAttachment((Control)xpndblcmpstClientes, 10);
        fd_xcDetallesDeVentas.bottom = new FormAttachment(0, 290);
        fd_xcDetallesDeVentas.top = new FormAttachment(0);
        this.xcDetallesDeVentas.setLayoutData((Object)fd_xcDetallesDeVentas);
        managedForm.getToolkit().paintBordersFor((Composite)this.xcDetallesDeVentas);
        this.xcDetallesDeVentas.setText("Resumen de Ventas por Cliente");
        Composite composite_3 = new Composite((Composite)this.xcDetallesDeVentas, 0);
        managedForm.getToolkit().adapt(composite_3);
        managedForm.getToolkit().paintBordersFor(composite_3);
        this.xcDetallesDeVentas.setClient((Control)composite_3);
        composite_3.setLayout((Layout)new BorderLayout(0, 0));
        ToolBar toolBar_1 = new ToolBar(composite_3, 0x820000);
        toolBar_1.setLayoutData((Object)"North");
        managedForm.getToolkit().adapt((Composite)toolBar_1);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar_1);
        this.tltmNuevoDetVenta = new ToolItem(toolBar_1, 0);
        this.tltmNuevoDetVenta.setText("Nuevo");
        this.tlmEditarDetalle = new ToolItem(toolBar_1, 4);
        this.tlmEditarDetalle.setText("Editar");
        this.tltmEliminarDetalle = new ToolItem(toolBar_1, 0);
        this.tltmEliminarDetalle.setText("Eliminar");
        this.menuEditar = new Menu((Control)this.tlmEditarDetalle.getParent().getShell());
        this.tltmEditarComprobante = new MenuItem(this.menuEditar, 0);
        this.tltmEditarComprobante.setText("Editar Comprobante");
        this.tltmEditarFormasDeCobro = new MenuItem(this.menuEditar, 0);
        this.tltmEditarFormasDeCobro.setText("Editar Formas de Cobro");
        this.tltmEditarFormasDeCobro.setEnabled(this.modeloDatos.periodo.isAnexoEnPeriodoDesdeJunio2016());
        DropdownSelectionListener dropListener = new DropdownSelectionListener(this.menuEditar);
        this.tlmEditarDetalle.addSelectionListener((SelectionListener)dropListener);
        this.tvDetallesComprobantes = new TableViewer(composite_3, 67584);
        this.tvDetallesComprobantes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaVentas.this.comprobanteSeleccionado = (ComprobanteVenta)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
            }
        });
        this.tblComprobantes = this.tvDetallesComprobantes.getTable();
        this.tblComprobantes.setLinesVisible(true);
        this.tblComprobantes.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.tblComprobantes);
        TableColumn tblclmnTipoComprobante = new TableColumn(this.tblComprobantes, 0);
        tblclmnTipoComprobante.setWidth(115);
        tblclmnTipoComprobante.setText("Tipo Comprobante");
        TableColumn tblclmnNoComprobantesEmitidos = new TableColumn(this.tblComprobantes, 0);
        tblclmnNoComprobantesEmitidos.setWidth(170);
        tblclmnNoComprobantesEmitidos.setText("No. Comprobantes Emitidos");
        TableColumn tblclmnBaseIva = new TableColumn(this.tblComprobantes, 0);
        tblclmnBaseIva.setWidth(100);
        tblclmnBaseIva.setText("Base IVA 0%");
        TableColumn tblclmnBaseIva_1 = new TableColumn(this.tblComprobantes, 0);
        tblclmnBaseIva_1.setWidth(100);
        tblclmnBaseIva_1.setText("Base IVA Dif. 0%");
        Section sctnVentasPorEstablecimiento = managedForm.getToolkit().createSection(composite, 258);
        managedForm.getToolkit().paintBordersFor((Composite)sctnVentasPorEstablecimiento);
        sctnVentasPorEstablecimiento.setText("Ventas por Establecimiento");
        sctnVentasPorEstablecimiento.setExpanded(true);
        sctnVentasPorEstablecimiento.setEnabled(this.modeloDatos.periodo.isPeriodoDesdeEnero2013());
        Composite composite_5 = new Composite((Composite)sctnVentasPorEstablecimiento, 0);
        managedForm.getToolkit().adapt(composite_5);
        managedForm.getToolkit().paintBordersFor(composite_5);
        sctnVentasPorEstablecimiento.setClient((Control)composite_5);
        composite_5.setLayout((Layout)new FormLayout());
        ExpandableComposite xcVentas = managedForm.getToolkit().createExpandableComposite(composite_5, 512);
        FormData fd_xcVentas = new FormData();
        fd_xcVentas.bottom = new FormAttachment(0, 280);
        fd_xcVentas.top = new FormAttachment(0);
        fd_xcVentas.left = new FormAttachment(0, 10);
        xcVentas.setLayoutData((Object)fd_xcVentas);
        managedForm.getToolkit().paintBordersFor((Composite)xcVentas);
        xcVentas.setText("Informaci\u00f3n de Ventas");
        Composite composite_8 = managedForm.getToolkit().createComposite((Composite)xcVentas, 0);
        managedForm.getToolkit().paintBordersFor(composite_8);
        xcVentas.setClient((Control)composite_8);
        composite_8.setLayout((Layout)new BorderLayout(0, 0));
        this.tvVentasEstab = new TableViewer(composite_8, 67584);
        this.tvVentasEstab.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PaginaVentas.this.establecimientoSeleccionado = (Establecimiento)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
            }
        });
        this.tblVentasEstab = this.tvVentasEstab.getTable();
        this.tblVentasEstab.setLayoutData((Object)"Center");
        this.tblVentasEstab.setLinesVisible(true);
        this.tblVentasEstab.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.tblVentasEstab);
        TableColumn tblclmnEstablecimiento = new TableColumn(this.tblVentasEstab, 0);
        tblclmnEstablecimiento.setWidth(125);
        tblclmnEstablecimiento.setText("Establecimiento");
        TableColumn tblclmnTotalVentas = new TableColumn(this.tblVentasEstab, 0);
        tblclmnTotalVentas.setWidth(125);
        tblclmnTotalVentas.setText("Total Ventas");
        TableColumn tblcmntTotalCompensacion = new TableColumn(this.tblVentasEstab, 0);
        tblcmntTotalCompensacion.setWidth(125);
        tblcmntTotalCompensacion.setText("Total Compensaci\u00f3n");
        Composite composite_9 = managedForm.getToolkit().createComposite(composite_8, 0);
        composite_9.setLayoutData((Object)"North");
        managedForm.getToolkit().paintBordersFor(composite_9);
        GridLayout gl_composite_9 = new GridLayout(2, false);
        gl_composite_9.marginHeight = 0;
        gl_composite_9.marginWidth = 0;
        composite_9.setLayout((Layout)gl_composite_9);
        Label lblNmeroDeEstablecimientos = new Label(composite_9, 0);
        GridData gd_lblNmeroDeEstablecimientos = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNmeroDeEstablecimientos.widthHint = 125;
        lblNmeroDeEstablecimientos.setLayoutData((Object)gd_lblNmeroDeEstablecimientos);
        managedForm.getToolkit().adapt((Control)lblNmeroDeEstablecimientos, true, true);
        lblNmeroDeEstablecimientos.setText("N\u00b0 de Establecimientos");
        this.lblNumEstablecimientos = new Label(composite_9, 0);
        GridData gd_lblNumEstablecimientos = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNumEstablecimientos.widthHint = 30;
        this.lblNumEstablecimientos.setLayoutData((Object)gd_lblNumEstablecimientos);
        managedForm.getToolkit().adapt((Control)this.lblNumEstablecimientos, true, true);
        this.lblNumEstablecimientos.setText("0");
        Composite composite_10 = new Composite(composite_9, 0);
        GridLayout gl_composite_10 = new GridLayout(1, false);
        gl_composite_10.verticalSpacing = 0;
        gl_composite_10.marginHeight = 0;
        gl_composite_10.marginWidth = 0;
        composite_10.setLayout((Layout)gl_composite_10);
        composite_10.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().adapt(composite_10);
        managedForm.getToolkit().paintBordersFor(composite_10);
        ToolBar tollBarEstab = new ToolBar(composite_10, 0x820000);
        managedForm.getToolkit().adapt((Composite)tollBarEstab);
        managedForm.getToolkit().paintBordersFor((Composite)tollBarEstab);
        this.tltmNuevoEstablecimiento = new ToolItem(tollBarEstab, 0);
        this.tltmNuevoEstablecimiento.setText("Nuevo");
        this.tltmEditarEstabl = new ToolItem(tollBarEstab, 0);
        this.tltmEditarEstabl.setText("Editar");
        this.tltmEliminarEstabl = new ToolItem(tollBarEstab, 0);
        this.tltmEliminarEstabl.setText("Eliminar");
        this.m_bindingContext = this.initDataBindings();
        this.btnNuevoClienteClicked();
        this.btnEditarClienteClicked();
        this.btnBuscarClicked();
        this.eliminarClienteVentaCliked();
        this.nuevoDetalleVentaClicked();
        this.btnEditarDetalleClicked();
        this.btnEditarFormasDeCobroClicked();
        this.btnEliminarDetalle();
        this.procesarModeloDatos();
        this.btnNuevoEstablecimientoClicked();
        this.btnEditarEstablecimientoClicked();
        this.btnEliminarEstablecimientoClicked();
    }

    private void nuevoDetalleVentaClicked() {
        this.tltmNuevoDetVenta.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaVentas.this.clienteSeleccionado != null) {
                    ComprobanteVenta comprobanteVenta = new ComprobanteVenta();
                    comprobanteVenta.setPropietario((ObjetoModelo)PaginaVentas.this.clienteSeleccionado);
                    List comprobantesExistentes = PaginaVentas.this.obtenerComprobantesExistentesParaValidarDuplicados();
                    AsistenteNuevoComprobanteVenta asistenteComprobanteVenta = new AsistenteNuevoComprobanteVenta(comprobanteVenta, comprobantesExistentes);
                    WizardDialog dialogoAsistenteNuevoComprobanteVenta = new WizardDialog(PaginaVentas.this.getSite().getShell(), (IWizard)asistenteComprobanteVenta);
                    if (dialogoAsistenteNuevoComprobanteVenta.open() == 0) {
                        PaginaVentas.this.clienteSeleccionado.agregarComprobantesVenta(comprobanteVenta);
                        PaginaVentas.this.calcularTotalVentasYCompesacionesPorCliente();
                        PaginaVentas.this.modeloDatos.actualizarTotalVentas();
                        ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                    }
                } else {
                    PaginaVentas.this.mostrarAdvertencia(PaginaVentas.NO_HA_SELECCIONADO_UN_CLIENTE_PARA_AGREGAR_COMPROBANTES);
                }
            }
        });
    }

    private void btnEditarDetalleClicked() {
        this.tltmEditarComprobante.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaVentas.this.comprobanteSeleccionado != null) {
                    ComprobanteVenta compCopia = PaginaVentas.this.comprobanteSeleccionado.crearCopiaEdicion();
                    List comprobantesExistentes = PaginaVentas.this.obtenerComprobantesExistentesParaValidarDuplicados();
                    AsistenteEdicionComprobanteVenta asistenteComprobanteVenta = new AsistenteEdicionComprobanteVenta(compCopia, comprobantesExistentes, AsistenteEdicionComprobanteVenta.SeccionVenta.COMPROBANTE);
                    WizardDialog dialogoAsistenteEditarComprobanteVenta = new WizardDialog(PaginaVentas.this.getSite().getShell(), (IWizard)asistenteComprobanteVenta);
                    if (dialogoAsistenteEditarComprobanteVenta.open() == 0) {
                        PaginaVentas.this.comprobanteSeleccionado.actualizarInformacion(compCopia);
                        PaginaVentas.this.calcularTotalVentasYCompesacionesPorCliente();
                        PaginaVentas.this.modeloDatos.actualizarTotalVentas();
                        PaginaVentas.this.tvDetallesComprobantes.refresh();
                        ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                    }
                } else {
                    PaginaVentas.this.mostrarError(PaginaVentas.NO_HA_SELECCIONADO_UN_DETALLE_DE_LA_VENTA);
                }
            }
        });
    }

    private void btnEditarFormasDeCobroClicked() {
        this.tltmEditarFormasDeCobro.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaVentas.this.comprobanteSeleccionado != null) {
                    if (((PaginaVentas)PaginaVentas.this).modeloDatos.periodo.isAnexoEnPeriodoDesdeJunio2016() && !VentasValidationRule.esNotaDeCreditoEnVentas((ComprobanteVenta)PaginaVentas.this.comprobanteSeleccionado)) {
                        ComprobanteVenta compCopia = PaginaVentas.this.comprobanteSeleccionado.crearCopiaEdicion();
                        List comprobantesExistentes = PaginaVentas.this.obtenerComprobantesExistentesParaValidarDuplicados();
                        AsistenteEdicionComprobanteVenta asistenteComprobanteVenta = new AsistenteEdicionComprobanteVenta(compCopia, comprobantesExistentes, AsistenteEdicionComprobanteVenta.SeccionVenta.FORMAS_COBRO);
                        WizardDialog dialogoAsistenteEditarComprobanteVenta = new WizardDialog(PaginaVentas.this.getSite().getShell(), (IWizard)asistenteComprobanteVenta);
                        if (dialogoAsistenteEditarComprobanteVenta.open() == 0) {
                            PaginaVentas.this.comprobanteSeleccionado.actualizarInformacion(compCopia);
                            ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                        }
                    } else {
                        PaginaVentas.this.mostrarError("No se pueden editar formas de cobro en el periodo vigente para notas de cr\u00e9dito");
                    }
                } else {
                    PaginaVentas.this.mostrarError(PaginaVentas.NO_HA_SELECCIONADO_UN_DETALLE_DE_LA_VENTA);
                }
            }
        });
    }

    private void calcularTotalVentasYCompesacionesPorCliente() {
        this.clienteSeleccionado.calcularTotalVentaPorCliente();
        this.clienteSeleccionado.calcularTotalCompensacionesPorCliente();
    }

    private List<AbstractMap.SimpleEntry<String, String>> obtenerComprobantesExistentesParaValidarDuplicados() {
        ArrayList<AbstractMap.SimpleEntry<String, String>> comprobantesExistentes = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        for (ComprobanteVenta comp : this.clienteSeleccionado.getComprobantesVenta()) {
            comprobantesExistentes.add(new AbstractMap.SimpleEntry<String, String>(comp.getTipoComprobante(), comp.getTipoEmision()));
        }
        return comprobantesExistentes;
    }

    private void btnEliminarDetalle() {
        this.tltmEliminarDetalle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaVentas.this.comprobanteSeleccionado != null && PaginaVentas.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaVentas.this.clienteSeleccionado.eliminarComprobantesVenta(PaginaVentas.this.comprobanteSeleccionado)) {
                    PaginaVentas.this.comprobanteSeleccionado = null;
                    PaginaVentas.this.clienteSeleccionado.calcularTotalVentaPorCliente();
                    PaginaVentas.this.modeloDatos.actualizarTotalVentas();
                    ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                }
            }
        });
    }

    private void btnNuevoEstablecimientoClicked() {
        this.tltmNuevoEstablecimiento.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Establecimiento establecimiento = new Establecimiento();
                establecimiento.setPropietario((ObjetoModelo)PaginaVentas.this.modeloDatos);
                if (PaginaVentas.this.abrirDialogoEstablecimiento(establecimiento, false)) {
                    PaginaVentas.this.modeloDatos.agregarEstablecimiento(establecimiento);
                    ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                }
            }
        });
    }

    private void btnEditarEstablecimientoClicked() {
        this.tltmEditarEstabl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaVentas.this.establecimientoSeleccionado != null) {
                    Establecimiento copiaEdicion = PaginaVentas.this.establecimientoSeleccionado.crearCopiaEdicion();
                    if (PaginaVentas.this.abrirDialogoEstablecimiento(copiaEdicion, true)) {
                        PaginaVentas.this.establecimientoSeleccionado.actualizarInformacion(copiaEdicion);
                        ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                    }
                } else {
                    PaginaVentas.this.mostrarError("No ha seleccionado un establecimiento");
                }
            }
        });
    }

    private boolean abrirDialogoEstablecimiento(Establecimiento modeloDatos, boolean editar) {
        DialogoEstablecimiento dialogo = new DialogoEstablecimiento(this.getSite(), this.modeloDatos.getEstablecimientos(), editar);
        dialogo.setModeloDatos(modeloDatos);
        return dialogo.open() == 0;
    }

    private void btnEliminarEstablecimientoClicked() {
        this.tltmEliminarEstabl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaVentas.this.establecimientoSeleccionado != null && PaginaVentas.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaVentas.this.modeloDatos.eliminarEstablecimiento(PaginaVentas.this.establecimientoSeleccionado)) {
                    PaginaVentas.this.establecimientoSeleccionado = null;
                    ((EditorATS)PaginaVentas.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaVentas.this.modeloDatos);
                }
            }
        });
    }

    private void btnBuscarClicked() {
        this.btnBuscar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!StringUtil.isNullOrEmpty((String)PaginaVentas.this.txtIdentificacion.getText())) {
                    for (Venta cl : PaginaVentas.this.modeloDatos.getClientesVenta()) {
                        if (!cl.getComprador().getIdentificacion().equals(PaginaVentas.this.txtIdentificacion.getText().trim())) continue;
                        AyudanteViewer.seleccionarElemento((Viewer)PaginaVentas.this.tvCliente, (Object)cl);
                        return;
                    }
                    PaginaVentas.this.mostrarError("No se encontro el cliente");
                } else {
                    PaginaVentas.this.mostrarError("No ha ingresado la identificaci\u00f3n para buscar");
                }
            }
        });
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), Venta.class, (String[])new String[]{"comprador.descripcionTipoIdentificacion", "comprador.identificacion", "totalVentaPorClienteInterfaz"});
        this.tvCliente.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.tvCliente.setContentProvider((IContentProvider)listContentProvider);
        IObservableList clientesVentaModeloDatosObserveList = BeanProperties.list((String)"clientesVenta").observe((Object)this.modeloDatos);
        this.tvCliente.setInput((Object)clientesVentaModeloDatosObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_1 = BeansObservables.observeMaps((IObservableSet)listContentProvider_1.getKnownElements(), ComprobanteVenta.class, (String[])new String[]{"descripcionTipoComprobante", "numeroEmitidos", "baseIvaCero", "baseIvaNoCero"});
        this.tvDetallesComprobantes.setLabelProvider((IBaseLabelProvider)new ProveedorEtiquetasTabla(observeMaps_1));
        this.tvDetallesComprobantes.setContentProvider((IContentProvider)listContentProvider_1);
        IViewerObservableValue observeSingleSelectionTvCliente = ViewerProperties.singleSelection().observe((Viewer)this.tvCliente);
        IObservableList tvClienteComprobantesVentaObserveDetailList = BeanProperties.list(Venta.class, (String)"comprobantesVenta", ComprobanteVenta.class).observeDetail((IObservableValue)observeSingleSelectionTvCliente);
        this.tvDetallesComprobantes.setInput((Object)tvClienteComprobantesVentaObserveDetailList);
        ISWTObservableValue observeTextLblTotalObserveWidget = WidgetProperties.text().observe((Widget)this.lblTotal);
        IObservableValue totalVentasInterfazModeloDatosObserveValue = BeanProperties.value((String)"totalVentasInterfaz").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextLblTotalObserveWidget, totalVentasInterfazModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_2 = BeansObservables.observeMaps((IObservableSet)listContentProvider_2.getKnownElements(), Establecimiento.class, (String[])new String[]{"establecimiento", "totalVentas", "totalCompensado"});
        this.tvVentasEstab.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps_2));
        this.tvVentasEstab.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList establecimientosModeloDatosObserveList = BeanProperties.list((String)"establecimientos").observe((Object)this.modeloDatos);
        this.tvVentasEstab.setInput((Object)establecimientosModeloDatosObserveList);
        ISWTObservableValue observeTextLblNumEstablecimientosObserveWidget = WidgetProperties.text().observe((Widget)this.lblNumEstablecimientos);
        IObservableValue numEstabRucModeloDatosObserveValue = BeanProperties.value((String)"numEstabRuc").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextLblNumEstablecimientosObserveWidget, numEstabRucModeloDatosObserveValue, null, null);
        ISWTObservableValue lblTotalReembolsosObserveTextObserveWidget = SWTObservables.observeText((Control)this.lblTotalReembolsos);
        IObservableValue modeloDatosTotalReembolsosInterfazObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"totalReembolsosInterfaz");
        bindingContext.bindValue((IObservableValue)lblTotalReembolsosObserveTextObserveWidget, modeloDatosTotalReembolsosInterfazObserveValue, null, null);
        return bindingContext;
    }
}

